﻿// yokaisplit.cpp : このファイルには 'main' 関数が含まれています。プログラム実行の開始と終了がそこで行われます。
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORD 65535
// 単語用メモリ
static char wordptr[MAX_WORD + 2][16]; // 65536単語×16バイト = 1MBほど確保
static char wordlen[MAX_WORD + 2]; // 文字列の長さ(最大14文字を想定)を確保。

int main(int argc, char* argv[])
{
    FILE* fp;
    static char ptr[256], inputstr[256];
    char *endptr;
    int mode = 0, detectFlag = 0, length = 0;
    unsigned long i = 0, word_count = 0;

    if (argc == 1) {
        printf("usage:yokailoop.exe passwords.txt\n");
        return 0;
    }

    // passwordsオープン
    if (fopen_s(&fp, argv[1], "rt") != 0) {
        printf("Password  File %s not found.\n", argv[1]);
        _fcloseall();
        return -1;
    }

    printf("検索したいキーワードを入力してください(スペース区切りでAND検索)\n");
    while (1) {
        printf("-\n>");
        gets_s(inputstr);
        if (inputstr[0] == '\0') break; // エンターで脱出
        fseek(fp, 0, SEEK_SET);
        word_count = 0;

        // 文字列を分離
        while (1) {
            endptr = strstr(inputstr," "); // スペース判定
            if (endptr == NULL) break; // 脱出
            inputstr[endptr - inputstr] = '\0'; // 発見位置を終端に
            strcpy_s(wordptr[word_count], inputstr);
            word_count++;
            strcpy_s(inputstr, endptr + 1);
            
        }
        strcpy_s(wordptr[word_count], inputstr); // 脱出後に書き込み
        word_count++;

        // passwords.txtにアタック
        while (fgets(ptr, 16, fp)) {
            detectFlag = 0;
            for (i = 0; i < word_count; i++) {
                if (strstr(ptr, wordptr[i])) {
                    detectFlag++;
                }else{
                    detectFlag = 0;
                }
            }
            if (detectFlag == word_count) {
                printf("%s", ptr);
            }
        }
    }


    _fcloseall();
    return 0;
}
