﻿// yokaisplit.cpp : このファイルには 'main' 関数が含まれています。プログラム実行の開始と終了がそこで行われます。
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORD 65535
// 単語用メモリ
static char wordptr[MAX_WORD + 2][16]; // 65536単語×16バイト = 1MBほど確保
static char wordlen[MAX_WORD + 2]; // 文字列の長さ(最大14文字を想定)を確保。

int main(int argc, char* argv[])
{
    FILE* fp;
    FILE* fp2;
    static char ptr[256];
    int mode = 0,detectFlag=0, length=0;
    unsigned long i = 0, word_count = 0;

    if (argc == 1) {
        printf("usage:yokaisplit.exe mode dict.txt passwords.txt\n");
        return 0;
    }

    // 第1引数を判断してモード切替(0 = 発見できたら出力 / 1 = 見つからなかったら出力)
    mode = (int)strtol(argv[1], NULL, 10);

    // dictオープン
    if (fopen_s(&fp, argv[2], "rt") != 0) {
        printf("Dict  File %s not found.\n", argv[2]);
        _fcloseall();
        return -1;
    }

    // passwordsオープン
    if (fopen_s(&fp2, argv[3], "rt") != 0) {
        printf("Password  File %s not found.\n", argv[3]);
        _fcloseall();
        return -1;
    }



    memset(wordptr, NULL, sizeof(wordptr));

    for (i = 0; i < MAX_WORD; i++) {
        // 1行が16文字を超えることは絶対ありえない(解析パスが14文字以下)という前提
        if (fgets(wordptr[i], 16, fp) == NULL) break;
        length = strlen(wordptr[i]);
        wordptr[i][length - 1] = '\0'; // 終端の改行コードを削る
    }
    word_count = i; // 単語数をキープ。この回数だけアタックを試行する。
    wordptr[i][0] = '*'; wordptr[i][1] = '\0'; // 念のため配列終端に番兵セット

    // passwords.txtにアタック
    while (fgets(ptr, 16, fp2)) {
        detectFlag = 0;
        for (i = 0; i < word_count; i++) {
            // 発見できたら出力のパターン
            if (mode == 0) {
                if (strstr(ptr, wordptr[i])) {
                    detectFlag = 1;
                    printf("%s", ptr);
                    break;
                }
            }
        }
        // 発見できなかった場合に出力パターン
        if (mode == 1 && detectFlag == 0) {
            printf("%s", ptr);
        }
    }


    _fcloseall();
    return 0;
}
