#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <nds/arm9/console.h>
#include <fat.h>

int main(void){
	FILE *fpr,*fpw;
	char read_buf[256];
	int i=0;

	// rfI
	videoSetMode(0);
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	vramSetBankC(VRAM_C_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	// t@CANZX錾
	if(!fatInitDefault()){
		iprintf("FAT Init error.");
		while(1);
	}

	// ǂݍ݃eXg
	iprintf("READ TEST : test.txt\n");
	if((fpr=fopen("test.txt","r"))==NULL){
		iprintf("FILE test.txt read failed."); while(0);
	}
	i=getc(fpr); iprintf("getc() test = [%c]\n",i);
	fgets(read_buf,2,fpr); read_buf[2]='\0'; iprintf("fgets() test = [%s]\n",read_buf);
	fread(read_buf,1,5,fpr); read_buf[5]='\0'; iprintf("fread() test = [%s]\n",read_buf);
	fclose(fpr);
	// ݃eXg
	iprintf("WRITE TEST : test2.txt\n");
	if((fpw=fopen("test2.txt","w"))==NULL){
		iprintf("FILE test2.txt write failed."); while(0);
	}
	if(putc('0',fpw)!=-1) iprintf("putc() test = OK\n");
	strcpy(read_buf,"1"); if(fputs(read_buf,fpw)!=EOF) iprintf("fputs() test = OK\n");
	strcpy(read_buf,"2"); if(fwrite(read_buf,1,1,fpw)!=0) iprintf("fwrite() test = OK\n");
	fclose(fpw);

	iprintf("\nDone.");
	while(1); // [v
	return 0;
}
