#include <nds.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nds/arm9/console.h>
#include <fat.h>
#define DUMPSIZE 33554432 // zoTCY(32KoCg)
#define BUFFSIZE 256

int main(void){
	FILE *fp;
	unsigned char read_buf[BUFFSIZE+1];
	unsigned char read_mir[BUFFSIZE+1];
	unsigned long i=0,j=0;
	// rfI
	videoSetMode(0);
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	vramSetBankC(VRAM_C_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);
	// t@CANZX錾t@C TEST.GBA 쐬
	if(!fatInitDefault()){
		iprintf("FAT Init error.");
		while(1);
	}
	if((fp=fopen("test.gba","wb"))==NULL){
		iprintf("File test.gba write failed.");
		while(1);
	}
	// ARM9 WAIT_CRZbg (WAIT_CR(0x6000);̂RPc)
	unsigned long *ulWait_cr=(unsigned long *)0x04000204;
	ulWait_cr[0]=0x6000;
	// GBAROM(0x8000000`)zoăt@Cۑ
	for(i=0;i<DUMPSIZE;i+=BUFFSIZE){
		// 1KoCgƂɏI[msAFFFFFF...ŒEo
		if(i>=1048576 && i%1048576==0){
			for(j=0;j<BUFFSIZE;j++){
				if(read_buf[j]!=0xFF) break;
			}
			if(j==BUFFSIZE) break;
		}
		// Ô2xǂ݁AlقȂ烊gC
		memcpy(read_buf,(unsigned char*)(0x8000000+i),BUFFSIZE+1);
		memcpy(read_mir,(unsigned char*)(0x8000000+i),BUFFSIZE+1);
		for(j=0;j<BUFFSIZE;j++) if(read_buf[j]!=read_mir[j]) break;
		if(j<BUFFSIZE){ i-=BUFFSIZE; continue; }
		fwrite(read_buf,BUFFSIZE,1,fp);
		printf("\x1b[2;2Hdumped=%ld",i);
	}
	// t@CN[Y[v
	fclose(fp);
	iprintf("\nDone.");
	while(1);
	return 0;
}
