#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>
#include "bg.h"
#include "apple.h"

// @XvCg\̒`
SpriteEntry sprites[128];
pSpriteRotation spriteRotations = (pSpriteRotation)sprites;

// AXvCg֐
void initSprites(void){
	for(int i = 0; i < 128; i++){
	   sprites[i].attribute[0] = ATTR0_DISABLED;
	   sprites[i].attribute[1] = 0;
	   sprites[i].attribute[2] = 0;
	   // ver1.4.6sprite.h[3]gȂ悤ɎdlύXH
	   //sprites[i].attribute[3] = 0;
    }
}

// BOAMXV
void updateOAM(void){
	DC_FlushRange(sprites,128*sizeof(SpriteEntry));
	dmaCopy(sprites, OAM, 128 * sizeof(SpriteEntry));
}

// C[`
int main(){
	touchPosition touchXY = touchReadXY();
    powerON(POWER_ALL_2D); irqInit(); irqSet(IRQ_VBLANK, 0);

	// CVRAM蓖Đݒ
	vramSetMainBanks(VRAM_A_MAIN_SPRITE, // VRAM_AɃXvCg
					 VRAM_B_MAIN_BG_0x06000000, // Bɔwi
					 VRAM_C_SUB_BG, // CɃTu(eLXg)
					 VRAM_D_LCD); // D͎gȂ

	// DCfBXvC[h5BBG + XvCggpŒ`B
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D | DISPLAY_SPR_1D_BMP);
	BG_PALETTE[0]=RGB15(0,0,0); BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK(31), (u16*)CHAR_BASE_BLOCK(0), 16);
	
	// ETufBXvCeLXg([h0)Œ`B
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	// FCfBXvC̔wi256x256摜蓖
	BG3_CR = BG_BMP8_256x256;
	dmaCopy(bgBitmap, BG_GFX, 256*256);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
	// wi̊gk]p[^(͓{BŶ݉Ɉړ)
	BG3_XDX = 1 << 8; BG3_XDY = 0; BG3_YDX = 0;
	BG3_YDY = 1 << 8; BG3_CX = 0; BG3_CY = 8 << 8;

	// GXvCgEԒ`EOtBbN]
	initSprites();
	// [0]̉1oCgYA[1]̉1oCgXB
	sprites[0].attribute[0] = ATTR0_COLOR_256 | ATTR0_ROTSCALE_DOUBLE | 30;
	sprites[0].attribute[1] = ATTR1_SIZE_16 | 60;
	sprites[0].attribute[2] = 0;
	spriteRotations[0].hdx=256; spriteRotations[0].hdy=0;
	spriteRotations[0].vdx=0; spriteRotations[0].vdy=256;
	swiCopy(applePal, SPRITE_PALETTE, 256);
	swiCopy(appleTiles, SPRITE_GFX, 16 * 16 / 2);

	// XN[㉺ւBオTuŉCƂȂB
	lcdSwap();

	iprintf("Sprite + BG + Text sample");
	while(1){
		// ^b`Ƃ̍WɃXvCgړ
		if(touchXY.px!=0){
			sprites[0].attribute[0] = ATTR0_COLOR_256 | ATTR0_ROTSCALE_DOUBLE | touchXY.py;
			sprites[0].attribute[1] = ATTR1_SIZE_16 |touchXY.px;
			// ^b`邲ƂɃIuWFNgg(Z)A104256ɖ߂
			spriteRotations[0].hdx--;
			spriteRotations[0].vdy--;
			if(spriteRotations[0].hdx==104){
				spriteRotations[0].hdx=256;
				spriteRotations[0].vdy=256;
			}
		}
		touchXY=touchReadXY();
		swiWaitForVBlank();
		// HXvCgXV
		updateOAM();
	}
}
