#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>
#include "bg.h"
// C[`
int main(){
	int iCX=0,iCY=0,iSize=256;
    powerON(POWER_ALL_2D); irqInit(); irqSet(IRQ_VBLANK, 0);	
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE);
	// 512x512ɂ256KBKvɂȂ邽߁AVRAM_A+VRAM_B256KBSĂBGɊ蓖ĂB
	vramSetMainBanks(VRAM_A_MAIN_BG_0x06000000,VRAM_B_MAIN_BG_0x06020000,VRAM_C_LCD,VRAM_D_LCD);
	BG3_CR = BG_BMP8_512x512;
	BG3_XDY = 0;
	BG3_YDX = 0;

	dmaCopy(bgBitmap, BG_GFX, 512*512);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
	// ㉺E
	while(1){
		scanKeys();
		if(keysHeld() & KEY_UP) iCY+=5;
		if(keysHeld() & KEY_DOWN) iCY-=5;
		if(keysHeld() & KEY_LEFT) iCX+=5;
		if(keysHeld() & KEY_RIGHT) iCX-=5;
		if(keysHeld() & KEY_A) iSize--;
		if(keysHeld() & KEY_B) iSize++;
		BG3_XDX = iSize;
		BG3_YDY = iSize;
		BG3_CX = iCX * iSize; 
		BG3_CY = iCY * iSize;
		swiWaitForVBlank();
	}
}