#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>
#include "bg.h"
#define SIZE_X 512
#define SIZE_Y 512
#define ANGLE 128
// C[`
int main(){
    powerON(POWER_ALL_2D); irqInit(); irqSet(IRQ_VBLANK, 0);
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE);
	vramSetMainBanks(VRAM_A_MAIN_BG_0x06000000,VRAM_B_LCD,VRAM_C_LCD,VRAM_D_LCD);
	BG3_CR = BG_BMP8_256x256;
	BG3_XDX = ( COS[ANGLE] >> 4) * SIZE_X >> 8;
	BG3_XDY = (-SIN[ANGLE] >> 4) * SIZE_X >> 8;
	BG3_YDX = ( SIN[ANGLE] >> 4) * SIZE_Y >> 8;
	BG3_YDY = ( COS[ANGLE] >> 4) * SIZE_Y >> 8;
	BG3_CX = 150 * SIZE_X; 
	BG3_CY = -50 * SIZE_Y;
	dmaCopy(bgBitmap, BG_GFX, 256*256);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
	while(1); // [vŒ~
}