#include <nds.h>
#include "apple.h"

SpriteEntry sprites[128];
pSpriteRotation spriteRotations = (pSpriteRotation)sprites;
// XvCg֐
void initSprites(void){
	for(int i = 0; i < 128; i++){
		sprites[i].attribute[0] = ATTR0_DISABLED;
		sprites[i].attribute[1] = 0;
		sprites[i].attribute[2] = 0;
    }
}
// OAMXV
void updateOAM(void){
	DC_FlushRange(sprites,128*sizeof(SpriteEntry));
	dmaCopy(sprites, OAM, 128 * sizeof(SpriteEntry));
}

// C[`
int main(){
    powerON(POWER_ALL_2D); irqInit(); irqSet(IRQ_VBLANK, 0);
	vramSetBankA(VRAM_A_MAIN_SPRITE); // VRAM_AXvCĝ
	videoSetMode(MODE_5_2D | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D); // [h5/XvCggp
	// XvCg
	initSprites();
	sprites[0].attribute[0] = ATTR0_COLOR_256 | ATTR0_ROTSCALE_DOUBLE | 80;
    sprites[0].attribute[1] = ATTR1_SIZE_16 | 100;
    sprites[0].attribute[2] = 0;
	spriteRotations[0].hdx=256; spriteRotations[0].hdy=0;
	spriteRotations[0].vdx=0; spriteRotations[0].vdy=256;
    // XvCg]
	swiCopy(appleTiles, SPRITE_GFX, 16*16);
	swiCopy(applePal, SPRITE_PALETTE, 256);
	// [v
	while(1){
		swiWaitForVBlank();
		updateOAM();
	}
}