#include <nds.h>
#include "icon.h"

SpriteEntry sprites[128];
pSpriteRotation spriteRotations = (pSpriteRotation)sprites;
// XvCg֐
void initSprites(void){
	for(int i = 0; i < 128; i++){
		sprites[i].attribute[0] = ATTR0_DISABLED;
		sprites[i].attribute[1] = 0;
		sprites[i].attribute[2] = 0;
    }
}
// OAMXV
void updateOAM(void){
	DC_FlushRange(sprites,128*sizeof(SpriteEntry));
	dmaCopy(sprites, OAM, 128 * sizeof(SpriteEntry));
}

// C[`
int main(){
	int i=0,iAngle=0;
	s16 s16sin,s16cos;

    powerON(POWER_ALL_2D); irqInit(); irqSet(IRQ_VBLANK, 0);
	vramSetBankA(VRAM_A_MAIN_SPRITE); // VRAM_AXvCĝ
	videoSetMode(MODE_5_2D | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D); // [h5/XvCggp
	// XvCg
	initSprites();
    // XvCg]
	swiCopy(iconTiles, SPRITE_GFX, 16*16*4/2);
	swiCopy(iconPal, SPRITE_PALETTE, 256);
	// XvCgZbg(4) W(X:50+i*32,Y:40+i*32)ցB
	for(i=0;i<=3;i++){
		sprites[i].attribute[0] = ATTR0_COLOR_256 | ATTR0_ROTSCALE_DOUBLE | (40+i*32);
	    sprites[i].attribute[1] = ATTR1_SIZE_16 | (50+i*32);
	    sprites[i].attribute[2] = i*8; // 8̔{ƂɃXvCgԍ؂ւ
	}

	// [v
	while(1){
		s16cos = COS[iAngle] >> 4;
		s16sin = SIN[iAngle] >> 4;
		// 8(5.625x)]A1]0xɖ߂
		if(iAngle>=504) iAngle=0; else iAngle+=8;
		// px̃p[^ZbgA\{256({)B
		for(i=0;i<=3;i++){
			spriteRotations[i].hdx=( s16cos * 256) >> 8;
			spriteRotations[i].hdy=(-s16sin * 256) >> 8;
			spriteRotations[i].vdx=( s16sin * 256) >> 8;
			spriteRotations[i].vdy=( s16cos * 256) >> 8;;
		}

		swiWaitForVBlank();
		updateOAM();
	}
}