#include <nds.h>
#include <stdio.h>
#include "apple.h"
#include "a32x32.h"

typedef struct
{
	u16* gfx;
	SpriteSize size;
	SpriteColorFormat format;
	int rotationIndex;
	int paletteAlpha;
	int x;
	int y;
}MySprite;

int main(int argc, char** argv){
	int i=0;
	MySprite sprites[] = {
		{0, SpriteSize_16x16, SpriteColorFormat_256Color, -1, 0, 20, 20},
		{0, SpriteSize_32x32, SpriteColorFormat_256Color, -1, 0, 80, 80}
	};

	// XN[
	videoSetMode(MODE_0_2D);
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	consoleDemoInit();

	// OAM
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	// XvCgZbg
	for(i=0;i<2;i++)
		sprites[i].gfx = oamAllocateGfx(&oamMain, sprites[i].size, sprites[i].format);
	// XvCg(S̊G)̃x[XƂȂpbĝݓ]
	swiCopy(applePal, SPRITE_PALETTE, 256);
	// OtBbNf[^Zbg
	swiCopy(appleTiles,sprites[0].gfx,16*16/2); // 16x16
	swiCopy(a32x32Tiles,sprites[1].gfx,32*32/2); // 32x32

	// XvCgZbg`̖[v
	while(1){
		for(i=0;i<2;i++){
			oamSet(&oamMain,i,sprites[i].x, sprites[i].y,0,sprites[i].paletteAlpha,
				sprites[i].size,sprites[i].format,sprites[i].gfx,sprites[i].rotationIndex,
				false,false);
		}
		swiWaitForVBlank();
		oamUpdate(&oamMain);
	}
	return 0;
}
