#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>
#include <string.h>
#include "char.h"
#include "stagedata.h"
#include "spr.h"
#define cls() iprintf("\x1b[2J");
#define locate(x,y) iprintf("\x1b[%d;%dH",y,x);
#define LAST_STAGE 4

// vg^Cv錾
void Title();		  // ^Cgʗp֐
void MyGraphicInit(); // OtBbN֐
void LoadStageData(); // Xe[Wf[^[h֐
void GetAndPutChar(); // L݁ݒu֐
void BounceRoutine(); // {[֐
void GameOver();	  // Q[I[o[֐
void StageClear();	  // Xe[WNA֐

// e֐ŋLϐ̓O[oŒ`
int iTouchChar=0,iTouchChar_x=0,iTouchChar_y=0,iBlink=0;
static char cStageMap[1024];
touchPosition touch;
u8* tileMemory = (u8*)BG_TILE_RAM(1);
u16* mapMemory = (u16*)BG_MAP_RAM(0);
u16* gfx;
float fBall_X=0,fBall_Y=0,fBounceX=1.5,fBounceY=1.5;
int iBlockCount=0,iSelectStage=0;
int iGameOverFlag=0;

// C[`
int main(){
	// OtBbN֐R[
	MyGraphicInit();

	// ^Cgʊ֐R[
	Title();
	// ȉA[v
	while(1){
		// Xe[Wf[^[h֐R[
		LoadStageData();
		// C[vуL݃[`
		while(!iGameOverFlag){ // Q[I[o[ɂȂȂ̓[v
			// j\ubNS󂵂Xe[WNAĂяoĒEo
			if(iBlockCount==0){
				StageClear();
				break;
			}
			touchRead(&touch);
			scanKeys();
			// ʂ^b`uԂɃL݁ݒu֐R[
			if((keysDown() & KEY_TOUCH)) GetAndPutChar();
			// Lłꍇ́A񂾃L2t[Ƃɓ_ł
			iBlink=~iBlink;
			if(iTouchChar){
				if(iBlink){
					mapMemory[iTouchChar_y*32 + (iTouchChar_x*2  )] = 12;
					mapMemory[iTouchChar_y*32 + (iTouchChar_x*2+1)] = 13;
				}else{
					mapMemory[iTouchChar_y*32 + (iTouchChar_x*2  )] = iTouchChar*2;
					mapMemory[iTouchChar_y*32 + (iTouchChar_x*2+1)] = iTouchChar*2+1;
				}
			}
			// {[֐R[
			BounceRoutine();

			locate(1,21); iprintf("Stage : %d    BlockCount : %03d",iSelectStage+1,iBlockCount);

			swiWaitForVBlank();
			oamUpdate(&oamMain);
		}
		// Q[I[o[ɂȂƃ[v𔲂ĂɂB
		iGameOverFlag=0; iTouchChar=0;
		cls();
	}
}


// OtBbN֐
void MyGraphicInit(){
	consoleDemoInit();
	// VRAM蓖Đݒ
	vramSetBankA(VRAM_A_MAIN_BG);
	vramSetBankB(VRAM_B_MAIN_SPRITE_0x06400000);
	vramSetBankC(VRAM_C_SUB_BG);
	// CfBXvC[h5Œ`B
	videoSetMode(MODE_5_2D | DISPLAY_BG0_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D_LAYOUT);
	REG_BG0CNT = BG_32x32 | BG_COLOR_256 | BG_MAP_BASE(0) | BG_TILE_BASE(1);
	// LN^OtBbNf[^(^C)[h
	swiCopy(charTiles, tileMemory, 8*8*14 / 2);
	swiCopy(charPal, BG_PALETTE, 256);
	// OAM : 256FBTCY16x16B
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	gfx = oamAllocateGfx(&oamMain, SpriteSize_16x16,SpriteColorFormat_256Color);
	// LN^OtBbNf[^(XvCg)[h
	swiCopy(sprPal, SPRITE_PALETTE, 256);
	swiCopy(sprTiles, SPRITE_GFX, 16 * 16 * 2 / 2);
}

// Xe[Wf[^ǂݍŃ^Czu
void LoadStageData(){
	unsigned long i=0;
	iSelectStage=0; // ftHgXe[W0ɃZbg
	while(1){
		iBlockCount=0; // ubNJEgZbgĂ
		locate(2,18); iprintf("Select Stage : %d",iSelectStage+1);
		locate(2,20); iprintf("A button     : Stage select");
		locate(2,21); iprintf("Start Button : Game Start");
		for(i=0;i<strlen(stagedata[iSelectStage]);i++){
			cStageMap[i] = stagedata[iSelectStage][i]-'0'; // cStageMapɃXe[Wf[^WJ
			mapMemory[i*2  ]=(stagedata[iSelectStage][i]-'0')*2;
			mapMemory[i*2+1]=(stagedata[iSelectStage][i]-'0')*2+1;
			if(cStageMap[i] && cStageMap[i]<4) iBlockCount++; // j\ubNJEg
		}
		// {[WXe[Wf[^Q
		fBall_X = m_fStartPointX[iSelectStage];
		fBall_Y = m_fStartPointY[iSelectStage];
		fBounceX = m_fBounceX[iSelectStage];
		fBounceY = m_fBounceY[iSelectStage];
		scanKeys(); // L[聕ʍXV
		if(keysDown()&KEY_START) break;
		if(keysDown()&KEY_A) iSelectStage++;
		if(iSelectStage==LAST_STAGE) iSelectStage=0; // ŏIXe[W̎1֖߂
		// ɃXvCg`悵ʍXV
		oamSet(&oamMain,0,(int)fBall_X-8,(int)fBall_Y-7,0,0,SpriteSize_16x16,
				SpriteColorFormat_256Color,gfx,-1,false,false,false,false,false);
		swiWaitForVBlank();
		oamUpdate(&oamMain);
	}
	cls(); // Ōɏʂ
}

// L݁ݒu֐
void GetAndPutChar(){
	// LłȂꍇ
	if(!iTouchChar){
		// Xe[Wf[^񂾃L
		iTouchChar_x = touch.px/16;
		iTouchChar_y = touch.py/8;
		iTouchChar = cStageMap[iTouchChar_y*16 + iTouchChar_x];
		// ߂ȂL̎̓^b`LZ
		if(iTouchChar>3) iTouchChar=0;
	}else{
	// ɃLłꍇ͐ݒu
		// ݒuꏊɊɃLȂƂmF
		if(cStageMap[(touch.py/8)*16 + (touch.px/16)]==0){
			// ̈ʒũL폜
			cStageMap[iTouchChar_y*16 + iTouchChar_x] = 0;
			mapMemory[iTouchChar_y*32 + (iTouchChar_x*2  )] = 0;
			mapMemory[iTouchChar_y*32 + (iTouchChar_x*2+1)] = 1;
			// VȃLݒu
			iTouchChar_x = touch.px/16;
			iTouchChar_y = touch.py/8;
			cStageMap[iTouchChar_y*16 + iTouchChar_x] = iTouchChar;
			mapMemory[iTouchChar_y*32 + (iTouchChar_x*2  )] = iTouchChar*2;
			mapMemory[iTouchChar_y*32 + (iTouchChar_x*2+1)] = iTouchChar*2+1;
			iTouchChar=0; // ݒu̓LZbg
		}
	}
}

// {[֐
void BounceRoutine(){
	int iBallChar_x=0,iBallChar_y=0;
	char cKnock_x=0,cKnock_y=0;

	// 炩߃{[̍WɐisẐLN^W֕ϊ
	iBallChar_x = (int)((fBall_X+fBounceX)/16);
	iBallChar_y = (int)((fBall_Y+fBounceY)/8 );

	// X̐isɂLo(Ŷ݌̂܂ܔ)
	cKnock_x = cStageMap[(int)(fBall_Y/8)*16 + iBallChar_x];
	switch(cKnock_x){
		case 1: //Փ˃L1(ʏubN)Ȃj󂵂ĕ]
			cStageMap[(int)(fBall_Y/8)*16 + iBallChar_x] = 0;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2] = 0;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2+1] = 1;
			fBounceX=-fBounceX; iBlockCount--;
		break;
		case 2: // 2(ubN)Ȃ1(ʏ)ɕύXĕ]
			cStageMap[(int)(fBall_Y/8)*16 + iBallChar_x] = 1;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2] = 2;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2+1] = 3;
			fBounceX=-fBounceX;
		break;
		case 3: // 3(򉻃ubN)͂̂܂ܔj󂵂Ȃђ
			cStageMap[(int)(fBall_Y/8)*16 + iBallChar_x] = 0;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2] = 0;
			mapMemory[(int)(fBall_Y/8)*32 + iBallChar_x*2+1] = 1;
			iBlockCount--;
		break;
		case 4: // ǂ͒Pɔ]邾
			fBounceX=-fBounceX;
		break;
		case 5: // gbvɐGꂽQ[I[o[[`
			GameOver();
			return; // ^[
		break;
		default:break;
	}
	// Y̐isɂLo(X̂݌̂܂ܔ)
	cKnock_y = cStageMap[iBallChar_y*16 + (int)(fBall_X/16)];
	switch(cKnock_y){
		case 1: //Փ˃L1(ʏubN)Ȃj󂵂ĕ]
			cStageMap[iBallChar_y*16 + (int)(fBall_X/16)] = 0;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2] = 0;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2+1] = 1;
			fBounceY=-fBounceY; iBlockCount--;
		break;
		case 2:
			cStageMap[iBallChar_y*16 + (int)(fBall_X/16)] = 1;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2] = 2;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2+1] = 3;
			fBounceY=-fBounceY;
		break;
		case 3: //Փ˃L1(ʏubN)Ȃj󂵂ĕ]
			cStageMap[iBallChar_y*16 + (int)(fBall_X/16)] = 0;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2] = 0;
			mapMemory[iBallChar_y*32 + (int)(fBall_X/16)*2+1] = 1;
			iBlockCount--;
		break;
		case 4: // ǂ͒Pɔ]邾
			fBounceY=-fBounceY;
		break;
		case 5: // gbvɐGꂽQ[I[o[[`
			GameOver();
		break;
		default:break;
	}
	// ŌɃ{[XvCg`
	oamSet(&oamMain,0,(int)fBall_X-8,(int)fBall_Y-7,0,0,SpriteSize_16x16,
				SpriteColorFormat_256Color,gfx,-1,false,false,false,false,false);

	fBall_X+=fBounceX;
	fBall_Y+=fBounceY;
}

// Q[I[o[[`
void GameOver(){
	cls();
	oamSet(&oamMain,0,(int)fBall_X-8,(int)fBall_Y-7,0,0,SpriteSize_16x16,
			SpriteColorFormat_256Color,gfx+128,-1,false,false,false,false,false);
	locate(8,17); iprintf("* Game Over *");
	locate(7,21);iprintf("[Press A button]");
	swiWaitForVBlank();
	oamUpdate(&oamMain);
	while(!(keysDown() & KEY_A)){
		scanKeys(); swiWaitForVBlank();
	}
	iGameOverFlag=1; // Q[I[o[tO𗧂Ă
}

// Xe[WNA[`
void StageClear(){
	cls();
	locate(7,17); iprintf("- Stage Clear! -");
	locate(7,21);iprintf("[Press A button]");
	swiWaitForVBlank();
	oamUpdate(&oamMain);
	while(!(keysDown() & KEY_A)){
		scanKeys(); swiWaitForVBlank();
	}
}

// ^Cgʊ֐
void Title(){
	int iBGX=0,iBGY=0; // XN[pϐ
	locate(7,8); iprintf("Touch & Bounce DS");
	locate(7,13);iprintf("[Press A button]");
	while(!(keysDown() & KEY_A)){
		REG_BG0HOFS=iBGX--; REG_BG0VOFS=iBGY++;
		scanKeys(); swiWaitForVBlank();
	}
	// ʏƃXN[ʒuZbgB
	cls(); REG_BG0HOFS=0; REG_BG0VOFS=0;
	// ɏI[ŏ㉺XN[ւB
	lcdSwap();
}