#include <nds.h>
#include <nds/arm9/console.h>
#include <stdio.h>
#include "bg.h"
#include "sprite.h"
#include "layout.h"

// O[oBGƃXvCgpϐ`
int bg3;

// ֐vg^Cv錾
void MyGraphicInit();
void LayoutSprites();

// C[`
int main(){
	// OtBbNBG摜EXvCg`
	MyGraphicInit();
	// ʃCAEgpXvCg`֐R[
	LayoutSprites();
	// C[v
	while(1){
		oamUpdate(&oamMain);
		swiWaitForVBlank();
	}
}

// OtBbN֐
void MyGraphicInit(){
	consoleDemoInit();
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	vramSetBankB(VRAM_B_MAIN_BG_0x06000000);
	vramSetBankC(VRAM_C_SUB_BG);
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D | DISPLAY_SPR_1D_BMP);
	lcdSwap(); // XN[㉺ւ
	// BG摜[h
	bg3 = bgInit(3, BgType_Bmp8, BgSize_B8_256x256,0,0);
	dmaCopy(bgBitmap, bgGetGfxPtr(bg3), 256*256);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
}

// XvCgCAEg֐
void LayoutSprites(){
	int i=0;
	// XvCg`
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	swiCopy(spritePal, SPRITE_PALETTE, 256); // pbg͕ʂɃ[h
	// wb_t@C layout.h ̓eɏ]ăXvCgʒuɃZbgB
	for(i=0;i<=CHAR_COUNT;i++){
		sprites[i].gfx = oamAllocateGfx(&oamMain, SpriteSize_32x32, SpriteColorFormat_256Color);
		swiCopy(spriteTiles+sprites[i].charNumber, sprites[i].gfx, 32*16);
		oamSet(&oamMain,i,sprites[i].x,sprites[i].y,0,0,
			SpriteSize_32x32,SpriteColorFormat_256Color,sprites[i].gfx,-1,
			false,false,false,false,false);
	}
}
