#include <nds.h>
#include <stdio.h>
#include "bg.h"
#include "sprite.h"
#include "layout.h"
#define REC_TIME 60 // ^(W60b)
#define sample_rate  8000
	
// O[oϐ`
int bg3; // BGp
u16* sound_buffer = 0;
u16* mic_buffer = 0;
u32 data_length = 0;
u32 sound_buffer_size = sample_rate * 2 * REC_TIME;
u32 mic_buffer_size = sample_rate * 2 / 30;

// ֐vg^Cv錾
void MyGraphicInit();
void LayoutSprites();
void InitSound();
void VoiceRec();
void micHandler(void* data, int length);
void PlayVoice();

// C[`
int main(){
	// ϐ
	unsigned long i=0;
	touchPosition touch;
	int iTouchParam=0;

	// OtBbNBG摜EXvCg`
	MyGraphicInit();
	// ʃCAEgpXvCg`֐R[
	LayoutSprites();
	// TEh
	InitSound();
	// C[v
	while(1){
		// ^b`
		touchRead(&touch);
		scanKeys();
		if((keysDown() & KEY_TOUCH)){
			// pl̓XvCg7ԁ`Ȃ̂ŁB
			for(i=7;i<=CHAR_COUNT;i++){
				if( touch.px>=sprites[i].x && touch.px<=sprites[i].x+32 &&
					touch.py>=sprites[i].y && touch.py<=sprites[i].y+32){
					iTouchParam=i;
					break;
				}else iTouchParam=0;
			}
			switch(iTouchParam){
				case 7 :iprintf("Play\n"); PlayVoice(); break;
				case 8 :iprintf("Rec\n");  VoiceRec();  break;
				case 9 :iprintf("Rew\n");break;
				case 10:iprintf("FF\n");break;
				case 11:iprintf("Stop\n"); soundMicOff(); soundDisable();break;
				case 12:iprintf("Track+\n");break;
				case 13:iprintf("Track-\n");break;
				default:break;
			}
		}
		// L[pbh
		if(keysDown() & KEY_A){ iprintf("Play\n"); PlayVoice(); }
		if(keysDown() & KEY_START){ iprintf("Rec\n"); VoiceRec(); }
		if(keysDown() & KEY_LEFT) iprintf("Rew\n");
		if(keysDown() & KEY_RIGHT) iprintf("FF\n");
		if(keysDown() & KEY_B){ iprintf("Stop\n"); soundMicOff(); soundDisable();}
		if(keysDown() & KEY_R) iprintf("Track+\n");
		if(keysDown() & KEY_L) iprintf("Track-\n");

		
		oamUpdate(&oamMain);
		swiWaitForVBlank();
	}
}

// OtBbN֐
void MyGraphicInit(){
	consoleDemoInit();
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	vramSetBankB(VRAM_B_MAIN_BG_0x06000000);
	vramSetBankC(VRAM_C_SUB_BG);
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D | DISPLAY_SPR_1D_BMP);
	lcdSwap(); // XN[㉺ւ
	// BG摜[h
	bg3 = bgInit(3, BgType_Bmp8, BgSize_B8_256x256,0,0);
	dmaCopy(bgBitmap, bgGetGfxPtr(bg3), 256*256);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
}

// XvCgCAEg֐
void LayoutSprites(){
	int i=0;
	// XvCg`
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	swiCopy(spritePal, SPRITE_PALETTE, 256); // pbg͕ʂɃ[h
	// wb_t@C layout.h ̓eɏ]ăXvCgʒuɃZbgB
	for(i=0;i<=CHAR_COUNT;i++){
		sprites[i].gfx = oamAllocateGfx(&oamMain, SpriteSize_32x32, SpriteColorFormat_256Color);
		swiCopy(spriteTiles+sprites[i].charNumber, sprites[i].gfx, 32*16);
		oamSet(&oamMain,i,sprites[i].x,sprites[i].y,0,0,
			SpriteSize_32x32,SpriteColorFormat_256Color,sprites[i].gfx,-1,
			false,false,false,false,false);
	}
}

// TEh֐
void InitSound(){
	// obt@me
	sound_buffer = (u16*)malloc(sound_buffer_size);
	mic_buffer = (u16*)malloc(mic_buffer_size);
}

// ^[`
void VoiceRec(){
	data_length = 0;
	soundMicRecord(mic_buffer, mic_buffer_size, MicFormat_12Bit, sample_rate, micHandler);
}

void micHandler(void* data, int length){
	if(!sound_buffer || data_length > sound_buffer_size) return;
	
	DC_InvalidateRange(data, length);

	dmaCopy(data, ((u8*)sound_buffer) + data_length, length);
	
	data_length += length;

	iprintf(".");
	
}

void PlayVoice(){
	soundMicOff();
	soundEnable();
	soundPlaySample(sound_buffer, SoundFormat_16Bit, data_length, sample_rate, 127, 64, false, 0);
}