#include <nds.h>
#include <stdio.h>
#include <fat.h>
#include "bg.h"
#include "sprite.h"
#include "layout.h"
#define REC_TIME 60 // ^(W60b)
//#define sample_rate  16000 // deSmuMEpfobO
#define sample_rate 8000
	
// O[oϐ`
int bg3; // BGp
u16* sound_buffer = 0;
u16* mic_buffer = 0;
u32 data_length = 0;
u32 sound_buffer_size = sample_rate * 2 * REC_TIME;
u32 mic_buffer_size = sample_rate * 2 / 30;
int m_iPlayChannel=-1; // Đ`l̃ftHg-1B
int m_iFlameCount=0,m_iSec=0,m_iMin=0; // t[b
int m_iTimerCountFlag=0; // ^C}[JEgXVۃtO
int m_iLastSec=0,m_iLastMin=0; // ^I_̃^C}[lێ
int m_iPlayPointer=0; // Đ|Cgi[pϐ
int m_iTrack=0; // gbNԍ

// ֐vg^Cv錾
void MyGraphicInit();
void LayoutSprites();
void InitSound();
void VoiceRec();
void micHandler(void* data, int length);
void PlayVoice();
void TimerCount();
void RefreshSprites();
void TimerReset();
void SaveTrackData();
void LoadTrackData();


// C[`
int main(){
	// ϐ
	unsigned long i=0;
	touchPosition touch;
	int iTouchParam=0;


	// OtBbNBG摜EXvCg`
	MyGraphicInit();
	// ʃCAEgpXvCg`֐R[
	LayoutSprites();
	// TEh
	InitSound();
	// FAT
	if(!fatInitDefault()) iprintf("FAT error.\n-safe mode-\n");
	
	
	// C[v
	while(1){
		// ^b`
		touchRead(&touch);
		scanKeys();
		if((keysDown() & KEY_TOUCH)){
			// pl̓XvCg7ԁ`Ȃ̂ŁB
			for(i=7;i<=CHAR_COUNT;i++){
				if( touch.px>=sprites[i].x && touch.px<=sprites[i].x+32 &&
					touch.py>=sprites[i].y && touch.py<=sprites[i].y+32){
					iTouchParam=i;
					break;
				}else iTouchParam=0;
			}
			switch(iTouchParam){
				case 7 :
					// ^ɂȂĐ{^ꍇ͒Eo
					if(m_iTimerCountFlag==1 || m_iTimerCountFlag==2) break;
					iprintf("Play\n");PlayVoice(); m_iTimerCountFlag=1; TimerReset(); break;
				case 8 :iprintf("Rec\n");  VoiceRec(); m_iTimerCountFlag=2; m_iPlayPointer=0; TimerReset(); break;
				case 9 :iprintf("Rew\n");
						if(m_iPlayPointer>0){
							soundKill(m_iPlayChannel); soundDisable();
							m_iPlayPointer--; m_iPlayChannel=-1;
						}
						TimerReset(); RefreshSprites();
						break;
				case 10:iprintf("FF\n");
						if(m_iPlayPointer<(m_iLastMin*60)+m_iLastSec){
							soundKill(m_iPlayChannel); soundDisable();
							m_iPlayPointer++; m_iPlayChannel=-1;
							TimerReset(); RefreshSprites();
						}
						break;
				case 11:iprintf("Stop\n"); soundKill(m_iPlayChannel); soundMicOff(); soundDisable();
						// ^ɒ~ꍇ͍ŏIlTĂ
						if(m_iTimerCountFlag==2){ m_iLastSec=m_iSec; m_iLastMin=m_iMin; }
						soundDisable();
						m_iTimerCountFlag=0; TimerReset(); RefreshSprites();
						break;
				case 12:iprintf("Track+\n");
						if(m_iTrack<99) m_iTrack++; // 99ȉł邩𔻒
						RefreshSprites(); // XvCgĕ`֐R[
						break;
				case 13:iprintf("Track-\n");
						if(m_iTrack!=0) m_iTrack--; // 0łȂΌZ
						RefreshSprites(); // XvCgĕ`֐R[
						break;
				default:break;
			}
		}
		// L[pbh
		if(keysDown() & KEY_A){
			// ^ɂȂĐ{^ꍇ͒Eo
			if(m_iTimerCountFlag==1 || m_iTimerCountFlag==2) break;
			iprintf("Play\n"); PlayVoice(); m_iTimerCountFlag=1; TimerReset();
		}
		if(keysDown() & KEY_START){ iprintf("Rec\n"); VoiceRec(); m_iTimerCountFlag=2; m_iPlayPointer=0; TimerReset(); }
		if(keysDown() & KEY_LEFT){
			iprintf("Rew\n");
			if(m_iPlayPointer>0){
				soundKill(m_iPlayChannel); soundDisable();
				m_iPlayPointer--; m_iPlayChannel=-1; TimerReset(); RefreshSprites();
			}
		}
		if(keysDown() & KEY_RIGHT){
			iprintf("FF\n");
			if(m_iPlayPointer<(m_iLastMin*60)+m_iLastSec){
				soundKill(m_iPlayChannel); soundDisable();
				m_iPlayPointer++; m_iPlayChannel=-1; TimerReset(); RefreshSprites();
			}
		}
		if(keysDown() & KEY_B){
			iprintf("Stop\n"); soundKill(m_iPlayChannel); soundMicOff(); soundDisable();
			if(m_iTimerCountFlag==2){ m_iLastSec=m_iSec; m_iLastMin=m_iMin; }
			m_iTimerCountFlag=0; TimerReset(); RefreshSprites();
		}
		if(keysDown() & KEY_R){
			iprintf("Track+\n");
			if(m_iTrack<99) m_iTrack++; // 99ȉł邩𔻒
			RefreshSprites(); // XvCgĕ`֐R[
		}
		if(keysDown() & KEY_L){
			iprintf("Track-\n");
			if(m_iTrack!=0) m_iTrack--; // 0łȂΌZ
			RefreshSprites(); // XvCgĕ`֐R[
		}
		if(keysDown() & KEY_X) SaveTrackData();
		if(keysDown() & KEY_Y) LoadTrackData();

		// ^C}[JEg֐R[
		if(m_iTimerCountFlag) TimerCount();
		oamUpdate(&oamMain);
		swiWaitForVBlank();
	}
}

// OtBbN֐
void MyGraphicInit(){
	consoleDemoInit();
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	vramSetBankB(VRAM_B_MAIN_BG_0x06000000);
	vramSetBankC(VRAM_C_SUB_BG);
	videoSetMode(MODE_5_2D | DISPLAY_BG3_ACTIVE | DISPLAY_SPR_ACTIVE | DISPLAY_SPR_1D | DISPLAY_SPR_1D_BMP);
	lcdSwap(); // XN[㉺ւ
	// BG摜[h
	bg3 = bgInit(3, BgType_Bmp8, BgSize_B8_256x256,0,0);
	dmaCopy(bgBitmap, bgGetGfxPtr(bg3), 256*256);
	dmaCopy(bgPal, BG_PALETTE, 256*2);
}

// XvCgCAEg֐
void LayoutSprites(){
	int i=0;
	// XvCg`
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	swiCopy(spritePal, SPRITE_PALETTE, 256); // pbg͕ʂɃ[h
	// wb_t@C layout.h ̓eɏ]ăXvCgʒuɃZbgB
	for(i=0;i<=CHAR_COUNT;i++){
		sprites[i].gfx = oamAllocateGfx(&oamMain, SpriteSize_32x32, SpriteColorFormat_256Color);
		swiCopy(spriteTiles+sprites[i].charNumber, sprites[i].gfx, 32*16);
		oamSet(&oamMain,i,sprites[i].x,sprites[i].y,0,0,
			SpriteSize_32x32,SpriteColorFormat_256Color,sprites[i].gfx,-1,
			false,false,false,false,false);
	}
}

// TEh֐
void InitSound(){
	// obt@me
	sound_buffer = (u16*)malloc(sound_buffer_size);
	mic_buffer = (u16*)malloc(mic_buffer_size);
}

// ^[`
void VoiceRec(){
	// Ƀ`l蓖čς݂̏ꍇKILL
	if(m_iPlayChannel!=-1) soundKill(m_iPlayChannel);
	m_iFlameCount=0; m_iSec=0; m_iMin=0; // JEg
	m_iPlayChannel=-1; // `lftHg(-1)ɃZbg
	data_length = 0;
	soundMicRecord(mic_buffer, mic_buffer_size, MicFormat_12Bit, sample_rate, micHandler);
}
void micHandler(void* data, int length){
	if(!sound_buffer || data_length > sound_buffer_size){
		m_iTimerCountFlag=0; // E܂ŒBۂ̓^C}[JEgtOOFF
		m_iLastSec=m_iSec; // bƕŏIlƂăZbg
		m_iLastMin=m_iMin;
		return;
	}
	DC_InvalidateRange(data, length);
	dmaCopy(data, ((u8*)sound_buffer) + data_length, length);
	data_length += length;
	iprintf(".");
}

void PlayVoice(){
	soundMicOff();
	soundEnable();
	// Đ̓O[oϐ m_iPlayChannelɃ`lҔ
	if(m_iPlayChannel==-1){
		m_iPlayChannel = soundPlaySample(sound_buffer+(m_iPlayPointer*sample_rate),SoundFormat_16Bit,
										data_length-(m_iPlayPointer*sample_rate), sample_rate, 127, 64, false, 0);
	}else{
		// 2ڂ̓W[čČĂяoB
		soundResume(m_iPlayChannel);
	}
}

// ^C}[JEg֐
void TimerCount(){
	// m_iTimerCountFlag1(Đ)ōŏIl𒴂Ăꍇ͍XV~߂
	if(m_iTimerCountFlag==1 && m_iMin>=m_iLastMin && m_iSec>=m_iLastSec){
		m_iTimerCountFlag=0;
		return;
	}
	// Jn0bڂ1b1xXV
	if(m_iFlameCount%60==0){
		// 0t[ڂɕbZȂ
		if(m_iFlameCount!=0) m_iSec++;
		// 60b1ÃXvCg(0)ĕb0ɃZbg
		// ̃Tvł͓ɘ^obt@săXgbvB
		if(m_iSec%60==0){
			m_iSec=0;
			// 0t[ڂŕZȂ
			if(m_iFlameCount!=0) m_iMin++;
		}
		RefreshSprites();
	}
	m_iFlameCount++; //t[Z
}

// ^C}[Zbg֐
void TimerReset(){
	m_iFlameCount=0;
	m_iSec=m_iPlayPointer%60;
	m_iMin=m_iPlayPointer/60;
}

// XvCgĕ`֐
void RefreshSprites(){
	// ĐԍXV
	sprites[0].charNumber=m_iMin * 256;
	swiCopy(spriteTiles+sprites[0].charNumber, sprites[0].gfx, 32*16);
	sprites[3].charNumber=(m_iSec%10) * 256;
	swiCopy(spriteTiles+sprites[3].charNumber, sprites[3].gfx, 32*16);
	sprites[2].charNumber=(m_iSec/10) * 256;
	swiCopy(spriteTiles+sprites[2].charNumber, sprites[2].gfx, 32*16);
	// gbNXV
	sprites[5].charNumber=(m_iTrack/10) * 256;
	swiCopy(spriteTiles+sprites[5].charNumber, sprites[5].gfx, 32*16);
	sprites[6].charNumber=(m_iTrack%10) * 256;
	swiCopy(spriteTiles+sprites[6].charNumber, sprites[6].gfx, 32*16);
}

// t@CZ[u֐
void SaveTrackData(){
	unsigned long i=0;
	char cPath[256],temp[256];
	FILE *fp;
	sprintf(cPath,"track_%02d.raw",m_iTrack);
	if((fp=fopen(cPath,"wb"))==NULL){
		sprintf(temp,"File %s write failed.\n",cPath);
		iprintf("%s",temp);
		fclose(fp);
		return;
	}
	sprintf(temp,"Write %s(size=%ldKB)\n",cPath,(long)sound_buffer_size/1024*sizeof(u16));
	iprintf("%s",temp);
	for(i=0;i<sound_buffer_size;i+=256){
		fwrite(sound_buffer+i,sizeof(u16),256,fp);
		if(!(i%8192)) iprintf(".");
	}
	fclose(fp);
	iprintf("Done.\n");
}

// t@C[h֐
void LoadTrackData(){
	unsigned long i=0;
	char cPath[256],temp[256];
	FILE *fp;
	sprintf(cPath,"track_%02d.raw",m_iTrack);
	if((fp=fopen(cPath,"rb"))==NULL){
		sprintf(temp,"File %s read failed.\n",cPath);
		iprintf("%s",temp);
		fclose(fp);
		return;
	}
	sprintf(temp,"Read %s(size=%ldKB)\n",cPath,(long)sound_buffer_size/1024*sizeof(u16));
	iprintf("%s",temp);
	// [NAĂobt@ɉf[^[h
	memset(sound_buffer,0,sound_buffer_size);
	for(i=0;i<sound_buffer_size;i+=256){
		fread(sound_buffer+i,sizeof(u16),256,fp);
		if(!(i%8192)) iprintf(".");
	}
	iprintf("ReadOK.");
	fclose(fp);
	// ep[^Zbg
	m_iSec=0; m_iMin=0; m_iFlameCount=0; m_iPlayPointer=0; m_iPlayChannel=-1;
	m_iLastSec=REC_TIME%60;
	m_iLastMin=REC_TIME/60;
	RefreshSprites(); // XvCgĕ`
	// ĐԂő咷ɃZbg(I_ołȂ)
	data_length = sound_buffer_size;
	iprintf("Done.\n");
}