#include <nds.h>
#include <maxmod9.h>
#include <stdio.h>
#include "music.h"
#include "music_bin.h"
#include "ballet.h"
#include "myship.h"

// O[oϐ
static int iBallet_x[256],iBallet_y[256],iBallet_type[256];
unsigned long ulTiming=0;

// XvCg\̒`
typedef struct{
	u16* gfx;
	SpriteSize size;
	int rotationIndex;
}MySprites;
MySprites sprites[] = {
	{0, SpriteSize_16x16, -1},	/* SprNo.0 @ */
	{0, SpriteSize_16x16, -1}	/* SprNo.1 Ge */
};
#define SetSpritesStatus(sss_id,sss_chr,sss_x,sss_y,sss_frame) \
	oamSet(&oamMain,sss_id,sss_x,sss_y,0,0,sprites[sss_chr].size,\
	SpriteColorFormat_256Color,sprites[sss_chr].gfx,\
	sprites[sss_chr].rotationIndex,false,false,false,false,false)

// R[obN֐
mm_word callbackEventHandler(mm_word msg,mm_word param){
	int j=0;
	switch(msg){
		case MMCB_SONGMESSAGE:
			for(j=0;j<=127;j++){
				if(iBallet_x[j]==-1){
					iBallet_x[j]    = music_bin[ulTiming++];
					iBallet_y[j]    = music_bin[ulTiming++] % 192;
					iBallet_type[j] = music_bin[ulTiming++];
					break;
				}
			}
			break;
		default:
			iprintf("unknown msg:%x %x\n",(int)msg,(int)param); break;
	}
	return 0;
}

int main() {
	int i=0;
	mmInitDefaultMem((mm_addr)music_bin); // MODǂݍ
	
	// ϐ
	memset(iBallet_x,-1,255);
	memset(iBallet_y,-1,255);
	memset(iBallet_type,-1,255);
	
	// CXN[̐ݒ
	lcdSwap();
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	vramSetBankB(VRAM_B_MAIN_BG_0x06000000);
	videoSetMode(MODE_3_2D);
	PrintConsole pc; 
	consoleInit(&pc, 1, BgType_Text4bpp, BgSize_T_256x256, 31, 0, true, true);

	// XvCgZbg
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	for(i=0;i<=1;i++)
		sprites[i].gfx = oamAllocateGfx(&oamMain, sprites[i].size, SpriteColorFormat_256Color);
	swiCopy(myshipTiles,sprites[0].gfx,myshipTilesLen/2);
	swiCopy(myshipPal, SPRITE_PALETTE, myshipPalLen);
	swiCopy(balletTiles,sprites[1].gfx,balletTilesLen/2);

	// R[obN֐Zbg
	mmSetEventHandler(callbackEventHandler);

	mmLoad(MOD_TW); // music.hɒ`ĂMODID
	mmStart(MOD_TW,MM_PLAY_LOOP); // MOD_TW[vĐ
	while(1){
		for(i=0;i<=127;i++){
			if(iBallet_x[i]!=-1) SetSpritesStatus(i,1,iBallet_x[i],iBallet_y[i],0);
		}
		oamUpdate(&oamMain);
		swiWaitForVBlank();
	}
}
