#include <nds.h>
#include <maxmod9.h>
#include <stdio.h>
#include "music.h"
#include "music_bin.h"
#include "ballet.h"
#include "myship.h"

// O[oϐ
static int iBallet_x[256],iBallet_y[256],iBallet_type[256];
unsigned long ulTiming=0x1000,ulScore=0;

// XvCg\̒`
typedef struct{
	u16* gfx;
	SpriteSize size;
	int rotationIndex;
}MySprites;
MySprites sprites[] = {
	{0, SpriteSize_16x16, -1},	/* SprNo.0 @ */
	{0, SpriteSize_16x16, -1}	/* SprNo.1 Ge */
};
#define SetSpritesStatus(sss_id,sss_chr,sss_x,sss_y,sss_frame) \
	oamSet(&oamMain,sss_id,sss_x,sss_y,0,0,sprites[sss_chr].size,\
	SpriteColorFormat_256Color,sprites[sss_chr].gfx,\
	sprites[sss_chr].rotationIndex,false,false,false,false,false)

// R[obN֐
mm_word callbackEventHandler(mm_word msg,mm_word param){
	int j=0;
	switch(msg){
		case MMCB_SONGMESSAGE:
			for(j=0;j<=127;j++){
				if(iBallet_x[j]==-50){
					iBallet_x[j]    = music_bin[ulTiming++];
					iBallet_y[j]    = music_bin[ulTiming++] % 192;
					iBallet_type[j] = music_bin[ulTiming++];
					iprintf("\x1b[0;5H%02x",iBallet_type[j]);
					break;
				}
			}
			break;
		case MMCB_SONGFINISHED:
			iprintf("MMCB_SONGFINISHED:%x\n",(int)param); break;
		default:
			iprintf("unknown msg:%x %x\n",(int)msg,(int)param); break;
	}
	return 0;
}

int main() {
	int i=0;
	touchPosition touchXY;
	mmInitDefaultMem((mm_addr)music_bin); // MODǂݍ
	
	// ϐ
	memset(iBallet_x,-50,255);
	memset(iBallet_y,-50,255);
	memset(iBallet_type,-50,255);

	// CXN[̐ݒ
	lcdSwap();
	vramSetBankA(VRAM_A_MAIN_SPRITE);
	vramSetBankB(VRAM_B_MAIN_BG_0x06000000);
	videoSetMode(MODE_3_2D);
	PrintConsole pc; 
	consoleInit(&pc, 1, BgType_Text4bpp, BgSize_T_256x256, 31, 0, true, true);

	// XvCgZbg
	oamInit(&oamMain, SpriteMapping_1D_32, false);
	for(i=0;i<=1;i++)
		sprites[i].gfx = oamAllocateGfx(&oamMain, sprites[i].size, SpriteColorFormat_256Color);
	swiCopy(myshipTiles,sprites[0].gfx,myshipTilesLen/2);
	swiCopy(myshipPal, SPRITE_PALETTE, myshipPalLen);
	swiCopy(balletTiles,sprites[1].gfx,balletTilesLen/2);

	// R[obN֐Zbg
	mmSetEventHandler(callbackEventHandler);

	mmLoad(MOD_TW); // music.hɒ`ĂMODID
	mmStart(MOD_TW,MM_PLAY_LOOP); // MOD_TW[vĐ
	while(1){
		printf("\x1b[0;8HScore : %08ld",ulScore);
		// @\
		touchRead(&touchXY);
		if(touchXY.px!=0 && touchXY.py!=0){
			SetSpritesStatus(127,0,touchXY.px-8,touchXY.py-8,0);
			ulScore++;
		}else{
			if(ulScore) ulScore--;
			SetSpritesStatus(127,0,-50,-50,0);			
		}

		// Ge\
		for(i=0;i<=126;i++){
			// WĂêݏ
			if(iBallet_x[i]!=-50){
				// ɉʓ̓GɏՓ˂ꍇɃQ[I[o[
				if(touchXY.px!=0 && touchXY.py!=0){
					if(touchXY.px>iBallet_x[i] && touchXY.px<=iBallet_x[i]+16 &&
					   touchXY.py>iBallet_y[i] && touchXY.py<=iBallet_y[i]+16){
					   	   iprintf("\x1b[10;10HGame Over\n");
					   	   swiWaitForVBlank();
					   	   while(1);
					}
				}
				SetSpritesStatus(i,1,iBallet_x[i],iBallet_y[i],0);
				// iBallet_type[]0x7Fȉ̓_e
				if(iBallet_type[i]<0x7F){
					iBallet_x[i] += (-rand()%8 + rand()%8);
					iBallet_y[i] += (-rand()%8 + rand()%8);
				}else{
					// ȏ̏ꍇ͉4rbgŔBÎ~ꍇ
					if(iBallet_type[i]&0x0001) iBallet_x[i]++;
					if(iBallet_type[i]&0x0002) iBallet_x[i]--;
					if(iBallet_type[i]&0x0004) iBallet_y[i]++;
					if(iBallet_type[i]&0x0008) iBallet_y[i]--;
				}

			}
			if(iBallet_x[i]<-16 || iBallet_x[i]>272 || iBallet_y[i]<-16 || iBallet_y[i]>208){
				iBallet_x[i]=-50; iBallet_y[i]=-50; iBallet_type[i]=-50;
				SetSpritesStatus(i,1,iBallet_x[i],iBallet_y[i],0);
			}
		}
		oamUpdate(&oamMain);
		swiWaitForVBlank();
	}
}
